<?php

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

function upi_crypto_manual_MetaData()
{
    return [
        'DisplayName' => 'UPI / Crypto / Binance Manual Payment',
        'APIVersion'  => '1.1',
    ];
}

function upi_crypto_manual_config()
{
    return [
        'FriendlyName' => [
            'Type'  => 'System',
            'Value' => 'UPI / Crypto / Binance Manual Payment',
        ],

        'upi_id' => [
            'FriendlyName' => 'UPI ID',
            'Type' => 'text',
            'Size' => '30',
            'Description' => 'Example: yourname@upi',
        ],
        'upi_qr' => [
            'FriendlyName' => 'UPI QR Image URL',
            'Type' => 'text',
            'Size' => '80',
            'Description' => 'Direct image URL',
        ],

        'usdt_address' => [
            'FriendlyName' => 'USDT (TRC20) Address',
            'Type' => 'text',
            'Size' => '80',
        ],
        'btc_address' => [
            'FriendlyName' => 'Bitcoin Address',
            'Type' => 'text',
            'Size' => '80',
        ],

        'binance_id' => [
            'FriendlyName' => 'Binance Pay ID',
            'Type' => 'text',
            'Size' => '40',
            'Description' => 'Binance Pay User ID',
        ],

        'instructions' => [
            'FriendlyName' => 'Payment Instructions',
            'Type' => 'textarea',
            'Rows' => '5',
            'Default' =>
                "1. Complete payment using any option below.\n" .
                "2. Open a support ticket.\n" .
                "3. Upload payment screenshot.\n" .
                "4. Mention Invoice ID.",
        ],
    ];
}

function upi_crypto_manual_link($params)
{
    $amount   = $params['amount'];
    $currency = $params['currency'];
    $invoice  = $params['invoiceid'];

    $html = '
<style>
.manual-box,
.manual-box * {
    color: #000 !important;
}

.manual-tabs { margin-top:15px; }

.manual-tabs button {
    border:1px solid #ddd;
    background:#f8f9fa;
    padding:8px 14px;
    margin-right:5px;
    cursor:pointer;
    border-radius:6px;
    color:#000 !important;
}

.manual-tabs button.active {
    background:#0d6efd;
    color:#fff !important; /* keep readable */
    border-color:#0d6efd;
}

.manual-tab-content {
    display:none;
    margin-top:15px;
    color:#000 !important;
}

.manual-tab-content.active {
    display:block;
}

.manual-box code {
    background:#f1f1f1;
    padding:6px 10px;
    border-radius:6px;
    display:inline-block;
    color:#000 !important;
}

.manual-box img {
    max-width:220px;
    border:1px solid #ddd;
    padding:6px;
    border-radius:8px;
}

.card-header2 {
    color:#000 !important;
    font-weight:600;
}

.manual-box .alert {
    color:#000 !important;
    background:#eef5ff;
    border-color:#cfe2ff;
}
</style>


<div class="card manual-box">
    <div class="card-header2">
        <strong>Payment Options</strong>
    </div>

    <div class="card-body">
        <p class="card-header2"><strong>Invoice ID:</strong> #' . $invoice . '</p>
        <p class="card-header2"><strong>Amount:</strong> ' . $amount . ' ' . $currency . '</p>

        <div class="manual-tabs">
            <button type="button" class="tab-btn active" data-tab="upiTab">UPI</button>
            <button type="button" class="tab-btn" data-tab="cryptoTab">Crypto</button>
            <button type="button" class="tab-btn" data-tab="binanceTab">Binance Pay</button>
        </div>

        <div id="upiTab" class="manual-tab-content active">
            ' . (!empty($params['upi_qr'])
                ? '<img src="' . $params['upi_qr'] . '"><br><br>'
                : '') . '
            <p><strong>UPI ID:</strong><br>
                <code>' . htmlspecialchars($params['upi_id']) . '</code>
            </p>
        </div>

        <div id="cryptoTab" class="manual-tab-content">
            ' . (!empty($params['usdt_address'])
                ? '<p class="card-header2"><strong>USDT (TRC20):</strong><br><code>' . htmlspecialchars($params['usdt_address']) . '</code></p>'
                : '') . '
            ' . (!empty($params['btc_address'])
                ? '<p class="card-header2"><strong>Bitcoin:</strong><br><code>' . htmlspecialchars($params['btc_address']) . '</code></p>'
                : '') . '
        </div>

        <div id="binanceTab" class="manual-tab-content">
            <p class="card-header2"><strong>Binance ID:</strong><br>
                <code>' . htmlspecialchars($params['binance_id']) . '</code>
            </p>
        </div>

        <div class="alert alert-info mt-3">
            After payment, open a support ticket and upload payment proof.<br>
            <strong>Mention Invoice ID #' . $invoice . '</strong>
        </div>
    </div>
</div>

<script>
(function(){
    var buttons = document.querySelectorAll(".tab-btn");
    var tabs = document.querySelectorAll(".manual-tab-content");

    buttons.forEach(function(btn){
        btn.addEventListener("click", function(){
            buttons.forEach(b => b.classList.remove("active"));
            tabs.forEach(t => t.classList.remove("active"));

            btn.classList.add("active");
            document.getElementById(btn.dataset.tab).classList.add("active");
        });
    });
})();
</script>';

    return $html;
}
